#version 430

layout(binding=0) uniform sampler2D texPotCenters;

in vec3 posV[];
in vec2 uvV[];

out vec4 posG;
out vec2 uvG;
out float perG;

vec4 rotateXY(vec4 p, float a) {
  vec4 r = p;
  r.x = cos(a)*p.x - sin(a)*p.y;
  r.y = sin(a)*p.x + cos(a)*p.y;
  return r;
}
vec4 rotateYZ(vec4 p, float a) {
  vec4 r = p;
  r.y = cos(a)*p.y - sin(a)*p.z;
  r.z = sin(a)*p.y + cos(a)*p.z;
  return r;
}
vec4 rotateXZ(vec4 p, float a) {
  vec4 r = p;
  r.x = cos(a)*p.x - sin(a)*p.z;
  r.z = sin(a)*p.x + cos(a)*p.z;
  return r;
}

vec3 rotateXY3(vec3 p, float a) {
  return rotateXY(vec4(p, 0.0), a).xyz;
}
vec3 rotateYZ3(vec3 p, float a) {
  return rotateYZ(vec4(p, 0.0), a).xyz;
}
vec3 rotateXZ3(vec3 p, float a) {
  return rotateXZ(vec4(p, 0.0), a).xyz;
}


layout(points) in;
layout(triangle_strip, max_vertices = 18) out;
//layout(line_strip, max_vertices = 15) out;


layout(binding=0, offset=0) uniform atomic_uint ac;

 
uniform mat4 projectionMatrix;
uniform mat4 modelViewMatrix;

uniform float g_time;

uniform float windowWidth = 1280.0;
uniform float windowHeight = 720.0;

layout(binding=0) uniform sampler2D tex;
layout(binding=2) uniform sampler2D texEmit;

uniform float g_pikselos = 0.0;

uniform float g_partSize = 0.15;


float atanSafe(float y, float x) {
 float ret=0.0;
        if (x!=0.0) {
                if (x>0.0) {
                        ret=atan(y/x);
                } else	{
                        ret=atan(y/x)+3.141592;
                }
        } else {
                if (y>=0.0) {
                        ret=0.5*3.141592;
                } else {
                        ret=-0.5*3.141592;
                }
        }
 return ret;
}

uniform float surfGridRes2D;

// 3D grid size which is the same for width, height & depth
uniform float surfGridDim3D;

// 1.0 scale puts the surfGrid to xyz coords varying from
// -surfGridDim3D*0.5 to surfGridDim3D*0.5
uniform float surfGridScale = 1.0;

// ivec2 ts = textureSize(s, 0);
// return texelFetch(s, ivec2(c.x*ts.x, c.y*ts.y), 0);


// gl_FragCoord.x

vec3 getPos3D(vec2 tp) {
    float kb = surfGridRes2D/surfGridDim3D; // 10 for example when dim3d is 100 and res2d is 1000
    vec3 pos3D = vec3(0.0);
    vec2 osa = tp/surfGridDim3D;
    vec2 cellXY = fract(osa)*surfGridDim3D;
    vec2 cellZ = floor(osa);
    float indZ = cellZ.x+cellZ.y*kb;
    pos3D = vec3(cellXY, indZ);
    return pos3D;
}

vec2 getPos2D(vec3 pos3D) {
    vec2 res;
    pos3D = floor(pos3D);
    float kb = surfGridRes2D/surfGridDim3D; // 10 for example when dim3d is 100 and res2d is 1000
    res.xy = fract(pos3D.xy/(surfGridDim3D+0))*(surfGridDim3D);
    float osa = floor(pos3D.z)/kb;
    res.x += fract(osa)*(surfGridRes2D);
    res.y += floor(osa)*(surfGridDim3D);
    return res;
}



void main(void) {
    if (gl_in.length()<1) {
        return;
    }

    if (gl_in.length()>1) {
        return;
    }

    mat4 mvp = projectionMatrix * modelViewMatrix;

    if (posV[0].z > surfGridDim3D-1.0) {
        return;
    }

    vec2 pos2D = getPos2D(posV[0]);

    vec4 pos = vec4(posV[0]-vec3(surfGridDim3D)*0.5, 1.0);
    vec4 pW = mvp*pos;

    vec2 munUv = uvV[0];
    int primID = gl_PrimitiveIDIn;

    gl_PrimitiveID = gl_PrimitiveIDIn;

    vec4 pot = texelFetch(texPotCenters, ivec2(pos2D.x, pos2D.y), 0);

    float per = clamp(0.50-abs(pot.r), 0.0, 0.50)*2.0;

    per = pow(per,8.0)*3.0;

    float pSize = 0.8*per;

    if (pSize < 0.001) {
      return;
    }

    float sizeX = pSize;
    float sizeY = pSize;
    float rotAngle = 0.0;
    float ar = 1.0;
    vec4 k;

    perG = pow(per, 1.0);

    k = rotateXY(vec4(-sizeX, -sizeY, 0.0, 0.0), rotAngle);
    gl_Position = pW+vec4(k.x*ar, k.y, 0.0, 0.0);
    posG = gl_Position;
    uvG = vec2(0.0, 0.0);
    EmitVertex();

    k = rotateXY(vec4(sizeX, -sizeY, 0.0, 0.0), rotAngle);
    gl_Position = pW+vec4(k.x*ar, k.y, 0.0, 0.0);
    posG = gl_Position;
    uvG = vec2(1.0, 0.0);
    EmitVertex();

    k = rotateXY(vec4(-sizeX, sizeY, 0.0, 0.0), rotAngle);
    gl_Position = pW+vec4(k.x*ar, k.y, 0.0, 0.0);
    posG = gl_Position;
    uvG = vec2(0.0, 1.0);
    EmitVertex();


    k = rotateXY(vec4(sizeX, sizeY, 0.0, 0.0), rotAngle);
    gl_Position = pW+vec4(k.x*ar, k.y, 0.0, 0.0);
    posG = gl_Position;
    uvG = vec2(1.0, 1.0);
    EmitVertex();

    EndPrimitive();
}
